﻿using System;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.AdvancedAPI.Sample3
{
    public partial class FormMain : Form
    {
        public enum HookType : int
        {
            WH_JournalRecord = 0x0,
            WH_JournalPlayback = 0x1,
            WH_Keyboard = 0x2,
            WH_GetMessage = 0x3,
            WH_CallWndProc = 0x4,
            WH_CBT = 0x5,
            WH_SysMsgFilter = 0x6,
            WH_Mouse = 0x7,
            WH_Hardware = 0x8,
            WH_Debug = 0x9,
            WH_Shell = 0xA,
            WH_ForEGroundIDLE = 0xB,
            WH_CallWndProcert = 0xC,
            WH_KeyboardLL = 0xD,
            WH_MouseLL = 0xE
        }

        public delegate IntPtr HookProc(int code, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll")]
        public static extern IntPtr SetWindowsHookEx(HookType hookType, HookProc lpFunction, IntPtr hMod, uint dwThreadId);

        [DllImport("user32.dll")]
        public static extern bool UnhookWindowsHookEx(IntPtr hookHandle);

        [DllImport("user32.dll")]
        public static extern IntPtr CallNextHookEx(IntPtr hookHandle, int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("kernel32.dll")]
        public static extern IntPtr GetModuleHandle(string lpModuleName);

        private enum MouseMessages
        {
            WM_LBUTTONDOWN = 0x0201,
            WM_LBUTTONUP = 0x0202,
            WM_MOUSEMOVE = 0x0200,
            WM_MOUSEWHEEL = 0x020A,
            WM_RBUTTONDOWN = 0x0204,
            WM_RBUTTONUP = 0x0205
        }

        [StructLayout(LayoutKind.Sequential)]
        private struct MouseHookStruct
        {
            public Point pt;
            public uint MouseData;
            public uint Flags;
            public uint Time;
            public IntPtr ExtraInfo;
        }

        private static readonly HookProc _proc = HookCallback;
        private static IntPtr _hookID = IntPtr.Zero;

        public static string TextResult { get; set; }

        private static IntPtr SetHook(HookProc proc)
        {
            using (Process curProcess = Process.GetCurrentProcess())
            using (ProcessModule curModule = curProcess.MainModule)
            {
                IntPtr myModuleHandle = GetModuleHandle(curModule.ModuleName);
                return SetWindowsHookEx(HookType.WH_MouseLL, proc, myModuleHandle, 0);
            }
        }

        private static IntPtr HookCallback(int nCode, IntPtr wParam, IntPtr lParam)
        {
            if (nCode >= 0 && MouseMessages.WM_LBUTTONDOWN == (MouseMessages)wParam)
            {
                MouseHookStruct hookStruct = (MouseHookStruct)Marshal.PtrToStructure(lParam, typeof(MouseHookStruct));
                TextResult = String.Format("[{0}, {1}] => Mouse Click", hookStruct.pt.X, hookStruct.pt.Y) + Environment.NewLine;
            }
            return CallNextHookEx(_hookID, nCode, wParam, lParam);
        }

        public FormMain()
        {
            InitializeComponent();
        }

        private void ButtonInstallHookClick(object sender, EventArgs e)
        {
            _hookID = SetHook(_proc);
            buttonUninstallHook.Enabled = true;
            buttonInstallHook.Enabled = false;
            timerGetString.Start();
        }

        private void ButtonUninstallHookClick(object sender, EventArgs e)
        {
            UnhookWindowsHookEx(_hookID);
            buttonUninstallHook.Enabled = false;
            buttonInstallHook.Enabled = true;
            timerGetString.Stop();
        }

        private void TimerGetStringTick(object sender, EventArgs e)
        {
            if (String.IsNullOrEmpty(TextResult)) return;
            textBoxResult.Text += TextResult;
            TextResult = String.Empty;
        }
    }
}